/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.exception.ValidationFileContentInvalidException;
import net.guerlab.smart.wx.core.exception.ValidationFileNameHasBlankErrorException;
import net.guerlab.smart.wx.core.exception.ValidationFileNameInvalidException;
import net.guerlab.smart.wx.core.exception.ValidationFileNameSuffixErrorException;
import net.guerlab.smart.wx.core.searchparams.ValidationFileSearchParams;
import net.guerlab.smart.wx.service.entity.ValidationFile;
import net.guerlab.smart.wx.service.mapper.ValidationFileMapper;
import net.guerlab.smart.wx.service.service.ValidationFileService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ValidationFileServiceImpl
extends BaseServiceImpl<ValidationFile, String, ValidationFileMapper, ValidationFileSearchParams>
implements ValidationFileService {
    public void insert(ValidationFile entity) {
        this.insertBefore(entity);
        ((ValidationFileMapper)this.getBaseMapper()).replaceInsert(entity);
    }

    protected void insertBefore(ValidationFile entity) {
        String fileName = StringUtils.trimToNull((String)entity.getFileName());
        String content = StringUtils.trimToNull((String)entity.getContent());
        if (fileName == null) {
            throw new ValidationFileNameInvalidException();
        }
        if (this.hasBlankCheck(fileName)) {
            throw new ValidationFileNameHasBlankErrorException();
        }
        if (!fileName.endsWith(".txt")) {
            throw new ValidationFileNameSuffixErrorException();
        }
        if (content == null) {
            throw new ValidationFileContentInvalidException();
        }
        entity.setFileName(fileName.replace(".txt", ""));
        entity.setContent(content);
    }

    private boolean hasBlankCheck(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected void updateBefore(ValidationFile entity) {
        entity.setContent(StringUtils.trimToNull((String)entity.getContent()));
    }
}

