/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.domain.RegisterStatistics;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.web.result.ListObject;

import java.util.Collection;

/**
 * 微信用户服务
 *
 * @author guer
 */
public interface WxUserService extends BaseService<WxUser, String, WxUserSearchParams> {

    /**
     * 通过搜索参数查询微信用户分页列表
     *
     * @param searchParams
     *         搜索参数
     * @return 分页列表
     */
    ListObject<WxUser> queryPage(WxUserSearchParams searchParams);

    /**
     * 通过搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 列表
     */
    Collection<WxUser> queryAll(WxUserSearchParams searchParams);

    /**
     * 通过appId和openId查询用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @return 微信用户
     */
    WxUser findUser(String appId, String openId);

    /**
     * 通过appId和openId删除用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     */
    void delete(String appId, String openId);

    /**
     * 查询注册统计信息
     *
     * @param searchParams
     *         查询参数
     * @return 注册统计信息
     */
    Collection<RegisterStatistics> selectRegisterStatistics(WxUserSearchParams searchParams);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<WxUser> getEntityClass() {
        return WxUser.class;
    }
}
