/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.server.service.BaseFindService;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.domain.LoginStatistics;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import org.springframework.scheduling.annotation.Async;

import java.util.Collection;

/**
 * 微信用户登录记录服务
 *
 * @author guer
 */
public interface WxUserLoginLogService extends BaseFindService<WxUserLoginLog, Long, WxUserLoginLogSearchParams> {

    /**
     * 添加登录记录
     *
     * @param user
     *         微信用户
     * @param ip
     *         IP
     * @param referer
     *         登录源
     */
    @Async
    void addLog(WxUser user, String ip, String referer);

    /**
     * 查询登录统计
     *
     * @param searchParams
     *         搜索参数
     * @return 登录统计
     */
    Collection<LoginStatistics> selectLoginStatistics(WxUserLoginLogSearchParams searchParams);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<WxUserLoginLog> getEntityClass() {
        return WxUserLoginLog.class;
    }
}
