/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.auth.factory.TokenFactory;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;

/**
 * 微信小程序登录服务
 *
 * @author guer
 */
public interface WxMaLoginService extends LoginService {

    /**
     * 注册
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @param encryptedData
     *         小程序加密信息请求
     * @param tokenFactory
     *         token工厂
     * @param ip
     *         登录IP
     * @return token
     */
    LoginResponse register(String appId, String openId, MaEncryptedData encryptedData, TokenFactory<IWxUserTokenInfo> tokenFactory, String ip);

    /**
     * 获取手机号
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @param encryptedData
     *         小程序加密信息请求
     * @return 手机号
     */
    String getPhoneNumber(String appId, String openId, MaEncryptedData encryptedData);
}
