/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import me.chanjar.weixin.cp.api.WxCpService;
import net.guerlab.smart.wx.core.utils.WxCpUtils;

/**
 * 企业微信服务管理
 *
 * @author guer
 */
public interface WxCpManagerService {

    /**
     * 获取服务
     *
     * @param corpId
     *         企业ID
     * @param agentId
     *         应用ID
     * @return 企业微信服务
     */
    default WxCpService getService(String corpId, Integer agentId) {
        return getService(WxCpUtils.buildAppId(corpId, agentId));
    }

    /**
     * 获取服务
     *
     * @param appId
     *         应用ID
     * @return 企业微信服务
     */
    WxCpService getService(String appId);
}
