/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.server.service.BaseBatchSaveService;
import net.guerlab.smart.platform.server.service.BaseDeleteService;
import net.guerlab.smart.platform.server.service.BaseFindService;
import net.guerlab.smart.wx.service.entity.UserTagMapping;
import net.guerlab.smart.wx.service.searchparams.UserTagMappingSearchParams;

/**
 * 微信用户标签映射关系服务
 *
 * @author guer
 */
public interface UserTagMappingService extends BaseFindService<UserTagMapping, Long, UserTagMappingSearchParams>, BaseBatchSaveService<UserTagMapping, UserTagMappingSearchParams>, BaseDeleteService<UserTagMapping, Long, UserTagMappingSearchParams> {

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<UserTagMapping> getEntityClass() {
        return UserTagMapping.class;
    }
}
