/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import net.guerlab.smart.wx.service.domain.RegisterStatistics;
import net.guerlab.smart.wx.service.entity.WxUser;

import java.util.List;
import java.util.Map;

/**
 * 微信用户 mapper
 *
 * @author guer
 */
public interface WxUserMapper extends BaseMapper<WxUser> {

    /**
     * 查询注册统计信息
     *
     * @param params
     *         查询参数
     * @return 注册统计信息
     */
    List<RegisterStatistics> selectRegisterStatistics(Map<String, Object> params);
}
