/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import net.guerlab.smart.wx.service.domain.LoginStatistics;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;

import java.util.List;
import java.util.Map;

/**
 * 微信用户登录记录 mapper
 *
 * @author guer
 */
public interface WxUserLoginLogMapper extends BaseMapper<WxUserLoginLog> {

    /**
     * 查询登录统计
     *
     * @param params
     *         搜索参数
     * @return 登录统计
     */
    List<LoginStatistics> selectLoginStatistics(Map<String, Object> params);
}
