/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.time.LocalDateTime;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Data
@TableName("wx_user_login_log")
public class WxUserLoginLog implements DefaultConvert<WxUserLoginLogDTO> {

    /**
     * 登录记录ID
     */
    @TableId
    private Long loginLogId;

    /**
     * openId
     */
    private String openId;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 头像地址
     */
    private String avatarUrl;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 登录时间
     */
    private LocalDateTime loginTime;

    /**
     * 账号是否已激活
     */
    private Boolean activated;

    /**
     * 登录IP
     */
    private String ip;

    /**
     * 登录源
     */
    private String referer;
}
