/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.enums.WxMsgDataFormat;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.time.LocalDateTime;

/**
 * 微信应用
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("wx_app")
public class WxApp extends BaseEntity implements DefaultConvert<WxAppDTO> {

    /**
     * 默认企业微信应用ID
     */
    public static final Integer DEFAULT_AGENT_ID = 0;

    /**
     * appId
     */
    @TableId
    private String appId;

    /**
     * 企业微信企业ID
     */
    @TableField(value = "corpId", updateStrategy = FieldStrategy.NEVER)
    private String corpId;

    /**
     * 企业微信应用ID,非企业微信ID为0
     */
    @TableField(value = "agentId", updateStrategy = FieldStrategy.NEVER)
    private Integer agentId;

    /**
     * secret
     */
    private String secret;

    /**
     * 微信应用类型
     */
    @TableField(value = "wxAppType", updateStrategy = FieldStrategy.NEVER)
    private WxAppType wxAppType;

    /**
     * token
     */
    private String token;

    /**
     * aesKey
     */
    private String aesKey;

    /**
     * 微信消息格式
     */
    private WxMsgDataFormat msgDataFormat;

    /**
     * 启用标签
     */
    private Boolean enable;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @TableField(value = "createTime", updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
