/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import net.guerlab.smart.wx.core.domain.ValidationFileDTO;
import net.guerlab.spring.commons.dto.DefaultConvert;

/**
 * 验证文件
 *
 * @author guer
 */
@Data
@TableName("wx_validation_file")
public class ValidationFile implements DefaultConvert<ValidationFileDTO> {

    /**
     * 文件名
     */
    @TableId
    private String fileName;

    /**
     * 文件内容
     */
    private String content;
}
