/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.autoconfigure;

import net.guerlab.smart.wx.miniapp.spring.storage.ISessionKeyStorage;
import net.guerlab.smart.wx.miniapp.spring.storage.SessionKeyRedisTemplateStorage;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 微信服务自动注册
 *
 * @author guer
 */
@EnableAsync
@Configurable
@ComponentScan("net.guerlab.smart.wx.service")
@MapperScan("net.guerlab.smart.wx.service.mapper")
public class WxServiceAutoconfigure {

    /**
     * 构造SessionKey储存接口
     *
     * @param redisTemplate
     *         redisTemplate
     * @return SessionKey储存接口
     */
    @Bean
    @ConditionalOnMissingBean
    public ISessionKeyStorage sessionKeyStorage(RedisTemplate<String, String> redisTemplate) {
        return new SessionKeyRedisTemplateStorage(redisTemplate);
    }
}
