/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.exception.AppIdInvalidException;
import net.guerlab.smart.wx.core.exception.OpenIdInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.domain.RegisterStatistics;
import net.guerlab.smart.wx.service.entity.UserTagMapping;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.handler.AfterWxUserUpdateHandler;
import net.guerlab.smart.wx.service.mapper.WxUserMapper;
import net.guerlab.smart.wx.service.searchparams.UserTagMappingSearchParams;
import net.guerlab.smart.wx.service.service.UserTagMappingService;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.smart.wx.stream.binders.WxAppChangeMessage;
import net.guerlab.smart.wx.stream.binders.WxAppChangeSubscriberChannel;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={WxAppChangeSubscriberChannel.class})
public class WxUserServiceImpl
extends BaseServiceImpl<WxUser, String, WxUserMapper, WxUserSearchParams>
implements WxUserService {
    private static final Logger log = LoggerFactory.getLogger(WxUserServiceImpl.class);
    private static final ThreadPoolExecutor EXECUTOR;
    private UserTagMappingService tagMappingService;

    @Override
    public ListObject<WxUser> queryPage(WxUserSearchParams searchParams) {
        if (this.refuseQuery(searchParams)) {
            return ListObject.empty();
        }
        return this.selectPage((AbstractSearchParams)searchParams);
    }

    @Override
    public Collection<WxUser> queryAll(WxUserSearchParams searchParams) {
        if (this.refuseQuery(searchParams)) {
            return Collections.emptyList();
        }
        return this.selectAll((AbstractSearchParams)searchParams);
    }

    private boolean refuseQuery(WxUserSearchParams searchParams) {
        if (NumberHelper.greaterZero((Number)searchParams.getTagId()) || CollectionUtil.isNotEmpty((Collection)searchParams.getTagIds())) {
            UserTagMappingSearchParams userTagMappingSearchParams = new UserTagMappingSearchParams();
            userTagMappingSearchParams.setTagId(searchParams.getTagId());
            userTagMappingSearchParams.setTagIds(searchParams.getTagIds());
            List openIds = CollectionUtil.toList((Collection)this.tagMappingService.selectAll(userTagMappingSearchParams), UserTagMapping::getOpenId);
            if (openIds.isEmpty()) {
                return true;
            }
            searchParams.setOpenIds((Collection)openIds);
        }
        return false;
    }

    @Override
    public WxUser findUser(String appId, String openId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, openId})) {
            return null;
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(appId);
        searchParams.setOpenId(openId);
        return (WxUser)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    @Override
    public void delete(String appId, String openId) {
        String trimAppId = StringUtils.trimToNull((String)appId);
        String trimOpenId = StringUtils.trimToNull((String)openId);
        if (trimAppId == null || trimOpenId == null) {
            return;
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(trimAppId);
        searchParams.setOpenId(trimOpenId);
        ((WxUserMapper)this.getBaseMapper()).delete((Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    @Override
    public Collection<RegisterStatistics> selectRegisterStatistics(WxUserSearchParams searchParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
        try {
            return ((WxUserMapper)this.getBaseMapper()).selectRegisterStatistics(params);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected void insertBefore(WxUser entity) {
        String appId = StringUtils.trimToNull((String)entity.getAppId());
        String openId = StringUtils.trimToNull((String)entity.getOpenId());
        if (appId == null) {
            throw new AppIdInvalidException();
        }
        if (openId == null) {
            throw new OpenIdInvalidException();
        }
        entity.setOpenId(openId);
        entity.setAppId(appId);
        entity.setUnionId(StringUtils.trimToEmpty((String)entity.getUnionId()));
        if (entity.getActivated() == null) {
            entity.setActivated(false);
        }
    }

    protected void updateBefore(WxUser entity) {
        EXECUTOR.execute(() -> SpringApplicationContextUtil.getContext().getBeansOfType(AfterWxUserUpdateHandler.class).values().forEach(handler -> handler.afterWxUserUpdateHandler(entity)));
    }

    @StreamListener(value="wx_app_change_input")
    public void wxAppChangeMessageHandler(Message<WxAppChangeMessage> message) {
        String appName;
        WxAppChangeMessage payload = (WxAppChangeMessage)message.getPayload();
        if (payload.isDeleteFlag()) {
            return;
        }
        String appId = StringUtils.trimToNull((String)payload.getAppId());
        String string = appName = payload.getApp() == null ? null : StringUtils.trimToNull((String)payload.getApp().getAppName());
        if (appId == null || appName == null) {
            return;
        }
        WxUser wxUser = new WxUser();
        wxUser.setAppName(appName);
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(appId);
        ((WxUserMapper)this.getBaseMapper()).update((Object)wxUser, (Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setTagMappingService(UserTagMappingService tagMappingService) {
        this.tagMappingService = tagMappingService;
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        EXECUTOR = new ThreadPoolExecutor(availableProcessors, availableProcessors * 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setName("wxUser updateBefore");
            return thread;
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
    }
}

