/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.domain.LoginStatistics;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import net.guerlab.smart.wx.service.handler.AfterWxUserUpdateHandler;
import net.guerlab.smart.wx.service.mapper.WxUserLoginLogMapper;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.smart.wx.stream.binders.WxAppChangeMessage;
import net.guerlab.smart.wx.stream.binders.WxAppChangeSubscriberChannel;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={WxAppChangeSubscriberChannel.class})
public class WxUserLoginLogServiceImpl
extends BaseServiceImpl<WxUserLoginLog, Long, WxUserLoginLogMapper, WxUserLoginLogSearchParams>
implements WxUserLoginLogService,
AfterWxUserUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(WxUserLoginLogServiceImpl.class);

    @Override
    public void addLog(WxUser user, String ip, String referer) {
        if (user == null) {
            return;
        }
        WxUserLoginLog log = new WxUserLoginLog();
        log.setLoginLogId(this.sequence.nextId());
        log.setOpenId(user.getOpenId());
        log.setAppId(user.getAppId());
        log.setAppName(user.getAppName());
        log.setUnionId(user.getUnionId());
        log.setAvatarUrl(user.getAvatarUrl());
        log.setNickName(user.getNickName());
        log.setActivated(user.getActivated());
        log.setLoginTime(LocalDateTime.now());
        log.setIp(StringUtils.trimToEmpty((String)ip));
        log.setReferer(StringUtils.trimToEmpty((String)referer));
        ((WxUserLoginLogMapper)this.getBaseMapper()).insert(log);
    }

    @Override
    public Collection<LoginStatistics> selectLoginStatistics(WxUserLoginLogSearchParams searchParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
        try {
            return ((WxUserLoginLogMapper)this.getBaseMapper()).selectLoginStatistics(params);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void afterWxUserUpdateHandler(WxUser wxUser) {
        boolean noUpdate;
        String openId = StringUtils.trimToNull((String)wxUser.getOpenId());
        String unionId = StringUtils.trimToEmpty((String)wxUser.getUnionId());
        String avatarUrl = StringUtils.trimToNull((String)wxUser.getAvatarUrl());
        String nickName = StringUtils.trimToNull((String)wxUser.getNickName());
        boolean bl = noUpdate = avatarUrl == null && nickName == null;
        if (openId == null || noUpdate) {
            return;
        }
        WxUserLoginLog update = new WxUserLoginLog();
        update.setUnionId(unionId);
        update.setAvatarUrl(avatarUrl);
        update.setNickName(nickName);
        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setOpenId(openId);
        ((WxUserLoginLogMapper)this.getBaseMapper()).update(update, (Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    @StreamListener(value="wx_app_change_input")
    public void wxAppChangeMessageHandler(Message<WxAppChangeMessage> message) {
        String appName;
        WxAppChangeMessage payload = (WxAppChangeMessage)message.getPayload();
        if (payload.isDeleteFlag()) {
            return;
        }
        String appId = StringUtils.trimToNull((String)payload.getAppId());
        String string = appName = payload.getApp() == null ? null : StringUtils.trimToNull((String)payload.getApp().getAppName());
        if (appId == null || appName == null) {
            return;
        }
        WxUserLoginLog update = new WxUserLoginLog();
        update.setAppName(appName);
        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setAppId(appId);
        ((WxUserLoginLogMapper)this.getBaseMapper()).update(update, (Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }
}

