/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.miniapp.spring.storate.WxMiniAppRedisTemplateConfigStorage;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.smart.wx.stream.binders.WxAppChangeMessage;
import net.guerlab.smart.wx.stream.binders.WxAppChangeSubscriberChannel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={WxAppChangeSubscriberChannel.class})
public class WxMaManagerServiceImpl
implements WxMaManagerService {
    private final Map<String, WxMaService> serviceMap = new ConcurrentHashMap<String, WxMaService>(8);
    private final Lock initLock = new ReentrantLock();
    private WxAppService wxAppService;
    private RedisTemplate<String, String> redisTemplate;

    @StreamListener(value="wx_app_change_input")
    public void wxAppChangeMessageHandler(Message<WxAppChangeMessage> message) {
        WxAppChangeMessage payload = (WxAppChangeMessage)message.getPayload();
        this.initLock.lock();
        try {
            this.serviceMap.remove(payload.getAppId());
        }
        finally {
            this.initLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxMaService getService(String appId) {
        if ((appId = StringUtils.trimToNull((String)appId)) == null) {
            return null;
        }
        WxMaService service = this.serviceMap.get(appId);
        if (service != null) {
            return service;
        }
        this.initLock.lock();
        try {
            WxMaConfig config = this.buildConfigStorage(appId);
            service = new WxMaServiceImpl();
            service.setWxMaConfig(config);
            this.serviceMap.put(appId, service);
            WxMaService wxMaService = service;
            return wxMaService;
        }
        finally {
            this.initLock.unlock();
        }
    }

    private WxMaConfig buildConfigStorage(String appId) {
        WxApp wxApp = (WxApp)((Object)this.wxAppService.selectById((Serializable)((Object)appId)));
        if (wxApp == null || wxApp.getWxAppType() != WxAppType.MINI_APP) {
            throw new WxAppInvalidException();
        }
        WxMiniAppRedisTemplateConfigStorage storage = new WxMiniAppRedisTemplateConfigStorage(this.redisTemplate);
        storage.setAppid(wxApp.getAppId());
        storage.setSecret(wxApp.getSecret());
        storage.setToken(wxApp.getToken());
        storage.setAesKey(wxApp.getAesKey());
        storage.setMsgDataFormat(wxApp.getMsgDataFormat().toString());
        return storage;
    }

    @Autowired
    public void setWxAppService(WxAppService wxAppService) {
        this.wxAppService = wxAppService;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

