/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service.impl;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseBatchServiceImpl;
import net.guerlab.smart.wx.service.entity.UserTagMapping;
import net.guerlab.smart.wx.service.mapper.UserTagMappingMapper;
import net.guerlab.smart.wx.service.searchparams.UserTagMappingSearchParams;
import net.guerlab.smart.wx.service.service.UserTagMappingService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 微信用户标签映射关系服务实现
 *
 * @author guer
 */
@Service
public class UserTagMappingServiceImpl extends BaseBatchServiceImpl<UserTagMapping, Long, UserTagMappingMapper, UserTagMappingSearchParams>
        implements UserTagMappingService {

    @Override
    protected UserTagMapping batchSaveBefore(UserTagMapping entity) {
        if (entity == null) {
            return null;
        }

        String openId = StringUtils.trimToNull(entity.getOpenId());
        entity.setOpenId(openId);

        if (openId == null || !NumberHelper.greaterZero(entity.getTagId())) {
            return null;
        }

        return entity;
    }
}
