/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import org.apache.commons.lang3.StringUtils;

/**
 * 用户标签服务
 *
 * @author guer
 */
public interface UserTagService extends BaseService<UserTag, Long, UserTagSearchParams> {

    /**
     * 通过标签名称查询标签
     *
     * @param tagName
     *         标签名称
     * @return 标签
     */
    default UserTag selectByName(String tagName) {
        if (StringUtils.isBlank(tagName)) {
            return null;
        }

        UserTagSearchParams searchParams = new UserTagSearchParams();
        searchParams.setTagName(tagName.trim());

        return selectOne(searchParams);
    }

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<UserTag> getEntityClass() {
        return UserTag.class;
    }
}
