/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 微信用户标签映射关系搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "UserTagMappingSearchParams", description = "微信用户标签映射关系搜索参数")
public class UserTagMappingSearchParams extends AbstractSearchParams {

    /**
     * openId
     */
    @Schema(description = "openId")
    private String openId;

    /**
     * openId列表
     */
    @Schema(description = "openId列表")
    @Column(name = "openId")
    @SearchModel(SearchModelType.IN)
    private Collection<String> openIds;

    /**
     * 标签ID
     */
    @Schema(description = "标签ID")
    private Long tagId;

    /**
     * 标签ID列表
     */
    @Schema(description = "标签ID列表")
    @Column(name = "tagId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> tagIds;
}
