/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.wx.core.domain.UserTagDTO;
import net.guerlab.spring.commons.dto.DefaultConvert;

/**
 * 用户标签
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("wx_user_tag")
public class UserTag extends BaseOrderEntity<UserTag> implements DefaultConvert<UserTagDTO> {

    /**
     * 标签ID
     */
    @TableId
    private Long tagId;

    /**
     * 标签名称
     */
    private String tagName;

}
