/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 登录统计
 *
 * @author guer
 */
@Data
@Schema(name = "LoginStatistics", description = "登录统计")
public class LoginStatistics {

    /**
     * appId
     */
    @Schema(description = "appId")
    private String appId;

    /**
     * 应用名称
     */
    @Schema(description = "应用名称")
    private String appName;

    /**
     * 登录总数
     */
    @Schema(description = "登录总数")
    private Integer count;

    /**
     * 按openId去重后登录总数
     */
    @Schema(description = "按openId去重后登录总数")
    private Integer distinctByOpenIdCount;
}
