package net.guerlab.smart.wx.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaSecCheckService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 小程序-内容安全服务实现
 *
 * @author guer
 */
@Service
public class WxMaContentSecurityServiceImpl implements WxMaContentSecurityService {

    private WxMaManagerService managerService;

    @Override
    public void checkImage(String appId, String fileUrl) {
        try {
            if (!getWxMaSecCheckService(appId).checkImage(fileUrl)) {

            }
        } catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e, e.getError().getErrorCode());
        }
    }

    @Override
    public void checkMessage(String appId, String msg) {
        try {
            if (getWxMaSecCheckService(appId).checkMessage(msg)) {

            }
        } catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e, e.getError().getErrorCode());
        }
    }

    private WxMaSecCheckService getWxMaSecCheckService(String appId) {
        WxMaService wxMaService = managerService.getService(appId);

        if (wxMaService == null) {
            throw new WxAppInvalidException();
        }

        return wxMaService.getSecCheckService();
    }

    @Autowired
    public void setManagerService(WxMaManagerService wxMaManagerService) {
        this.managerService = wxMaManagerService;
    }
}
