package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.platform.server.service.BaseService;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import org.apache.commons.lang3.StringUtils;

/**
 * 用户标签服务
 *
 * @author guer
 */
public interface UserTagService extends BaseService<UserTag, Long> {

    /**
     * 通过标签名称查询标签
     *
     * @param tagName
     *         标签名称
     * @return 标签
     */
    default UserTag selectByName(String tagName) {
        if (StringUtils.isBlank(tagName)) {
            return null;
        }

        UserTagSearchParams searchParams = new UserTagSearchParams();
        searchParams.setTagName(tagName.trim());

        return selectOne(searchParams);
    }

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<UserTag> getEntityClass() {
        return UserTag.class;
    }
}
