package net.guerlab.smart.wx.service.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.util.Collection;

/**
 * 微信用户标签映射关系搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("微信用户标签映射关系搜索参数")
public class UserTagMappingSearchParams extends AbstractSearchParams {

    /**
     * openId
     */
    @ApiModelProperty("openId")
    private String openId;

    /**
     * openId列表
     */
    @ApiModelProperty("openId列表")
    @Column(name = "openId")
    @SearchModel(SearchModelType.IN)
    private Collection<String> openIds;

    /**
     * 标签ID
     */
    @ApiModelProperty("标签ID")
    private Long tagId;

    /**
     * 标签ID列表
     */
    @ApiModelProperty("标签ID列表")
    @Column(name = "tagId")
    @SearchModel(SearchModelType.IN)
    private Collection<Long> tagIds;
}
