package net.guerlab.smart.wx.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;

/**
 * 微信用户
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "wx_user")
public class WxUser extends BaseEntity implements ConvertDTO<WxUserDTO>, IWxUserTokenInfo {

    /**
     * openId
     */
    @Id
    private String openId;

    /**
     * 应用ID
     */
    @Column(name = "appId", nullable = false, updatable = false)
    private String appId;

    /**
     * 应用名称
     */
    @Column(name = "appName", nullable = false)
    private String appName;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 头像地址
     */
    private String avatarUrl;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 注册时间
     */
    private LocalDateTime registryTime;

    /**
     * 最后登录时间
     */
    @Column(name = "lastLoginTime", nullable = false)
    private LocalDateTime lastLoginTime;

    /**
     * 账号是否已激活
     */
    @Column(name = "activated", nullable = false)
    private Boolean activated;

    /**
     * 标签ID列表
     */
    @Transient
    private Collection<Long> tagIds;

    /**
     * 标签列表
     */
    @Transient
    private Collection<UserTag> tags;

    @Override
    public WxUserDTO toDTO() {
        WxUserDTO dto = new WxUserDTO();

        BeanUtils.copyProperties(this, dto);
        dto.setTagIds(tagIds == null ? Collections.emptyList() : tagIds);
        dto.setTags(BeanConvertUtils.toList(tags));

        return dto;
    }
}
