package net.guerlab.smart.wx.service.service;

import me.chanjar.weixin.cp.api.WxCpService;
import net.guerlab.smart.wx.core.utils.WxCpUtils;

/**
 * 企业微信服务管理
 *
 * @author guer
 */
public interface WxCpManagerService {

    /**
     * 获取服务
     *
     * @param corpId
     *         企业ID
     * @param agentId
     *         应用ID
     * @return 企业微信服务
     */
    default WxCpService getService(String corpId, Integer agentId) {
        return getService(WxCpUtils.buildAppId(corpId, agentId));
    }

    /**
     * 获取服务
     *
     * @param appId
     *         应用ID
     * @return 企业微信服务
     */
    WxCpService getService(String appId);
}
