package net.guerlab.smart.wx.service.entity;

import lombok.Data;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Data
@Table(name = "wx_user_login_log")
public class WxUserLoginLog implements DefaultConvertDTO<WxUserLoginLogDTO> {

    /**
     * 登录记录ID
     */
    @Id
    private Long loginLogId;

    /**
     * openId
     */
    private String openId;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 头像地址
     */
    private String avatarUrl;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 登录时间
     */
    private LocalDateTime loginTime;

    /**
     * 账号是否已激活
     */
    private Boolean activated;

    /**
     * 登录IP
     */
    private String ip;

    /**
     * 登录源
     */
    private String referer;
}
