package net.guerlab.smart.wx.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseOrderEntity;
import net.guerlab.smart.wx.core.domain.UserTagDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 用户标签
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "wx_user_tag")
public class UserTag extends BaseOrderEntity<UserTag> implements DefaultConvertDTO<UserTagDTO> {

    /**
     * 标签ID
     */
    @Id
    private Long tagId;

    /**
     * 标签名称
     */
    private String tagName;

}
