package net.guerlab.smart.wx.service.autoconfigure;

import net.guerlab.smart.wx.miniapp.spring.storage.ISessionKeyStorage;
import net.guerlab.smart.wx.miniapp.spring.storage.SessionKeyRedisTemplateStorage;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableAsync;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * 微信服务自动注册
 *
 * @author guer
 */
@EnableAsync
@Configurable
@ComponentScan("net.guerlab.smart.wx.service")
@MapperScan("net.guerlab.smart.wx.service.mapper")
public class WxServiceAutoconfigure {

    /**
     * 构造SessionKey储存接口
     *
     * @param redisTemplate
     *         redisTemplate
     * @return SessionKey储存接口
     */
    @Bean
    @ConditionalOnMissingBean
    public ISessionKeyStorage sessionKeyStorage(RedisTemplate<String, String> redisTemplate) {
        return new SessionKeyRedisTemplateStorage(redisTemplate);
    }
}
