/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaSecCheckService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMaContentSecurityServiceImpl
implements WxMaContentSecurityService {
    private WxMaManagerService managerService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkImage(String appId, String fileUrl) {
        try {
            if (this.getWxMaSecCheckService(appId).checkImage(fileUrl)) return;
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkMessage(String appId, String msg) {
        try {
            if (!this.getWxMaSecCheckService(appId).checkMessage(msg)) return;
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
    }

    private WxMaSecCheckService getWxMaSecCheckService(String appId) {
        WxMaService wxMaService = this.managerService.getService(appId);
        if (wxMaService == null) {
            throw new WxAppInvalidException();
        }
        return wxMaService.getSecCheckService();
    }

    @Autowired
    public void setManagerService(WxMaManagerService wxMaManagerService) {
        this.managerService = wxMaManagerService;
    }
}

