package net.guerlab.smart.wx.service.service.impl;

import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import net.guerlab.smart.wx.service.handler.AfterWxAppUpdateHandler;
import net.guerlab.smart.wx.service.handler.AfterWxUserUpdateHandler;
import net.guerlab.smart.wx.service.mapper.WxUserLoginLogMapper;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * 微信用户登录记录服务实现
 *
 * @author guer
 */
@Service
public class WxUserLoginLogServiceImpl extends BaseServiceImpl<WxUserLoginLog, Long, WxUserLoginLogMapper>
        implements WxUserLoginLogService, AfterWxUserUpdateHandler, AfterWxAppUpdateHandler {

    @Override
    public void addLog(WxUser user, String ip, String referer) {
        if (user == null) {
            return;
        }

        WxUserLoginLog log = new WxUserLoginLog();
        log.setLoginLogId(sequence.nextId());
        log.setOpenId(user.getOpenId());
        log.setAppId(user.getAppId());
        log.setAppName(user.getAppName());
        log.setUnionId(user.getUnionId());
        log.setAvatarUrl(user.getAvatarUrl());
        log.setNickName(user.getNickName());
        log.setActivated(user.getActivated());
        log.setLoginTime(LocalDateTime.now());
        log.setIp(StringUtils.trimToEmpty(ip));
        log.setReferer(StringUtils.trimToEmpty(referer));

        mapper.insertSelective(log);
    }

    @Override
    public void afterWxUserUpdateHandler(WxUser wxUser) {
        String openId = StringUtils.trimToNull(wxUser.getOpenId());
        String unionId = StringUtils.trimToEmpty(wxUser.getUnionId());
        String avatarUrl = StringUtils.trimToNull(wxUser.getAvatarUrl());
        String nickName = StringUtils.trimToNull(wxUser.getNickName());
        boolean noUpdate = avatarUrl == null && nickName == null;

        if (openId == null || noUpdate) {
            return;
        }

        WxUserLoginLog update = new WxUserLoginLog();
        update.setUnionId(unionId);
        update.setAvatarUrl(avatarUrl);
        update.setNickName(nickName);

        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setOpenId(openId);

        mapper.updateByExampleSelective(update, getExample(searchParams));
    }

    @Override
    public void afterWxAppUpdateHandler(WxApp wxApp) {
        String appId = StringUtils.trimToNull(wxApp.getAppId());
        String appName = StringUtils.trimToNull(wxApp.getAppName());

        if (appId == null || appName == null) {
            return;
        }

        WxUserLoginLog update = new WxUserLoginLog();
        update.setAppName(appName);

        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setAppId(appId);

        mapper.updateByExampleSelective(update, getExample(searchParams));
    }
}
