package net.guerlab.smart.wx.service.service.impl;

import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseBatchServiceImpl;
import net.guerlab.smart.wx.service.entity.UserTagMapping;
import net.guerlab.smart.wx.service.mapper.UserTagMappingMapper;
import net.guerlab.smart.wx.service.service.UserTagMappingService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 微信用户标签映射关系服务实现
 *
 * @author guer
 */
@Service
public class UserTagMappingServiceImpl extends BaseBatchServiceImpl<UserTagMapping, Long, UserTagMappingMapper>
        implements UserTagMappingService {

    @Override
    protected UserTagMapping batchSaveBefore(UserTagMapping entity) {
        if (entity == null) {
            return null;
        }

        String openId = StringUtils.trimToNull(entity.getOpenId());
        entity.setOpenId(openId);

        if (openId == null || !NumberHelper.greaterZero(entity.getTagId())) {
            return null;
        }

        return entity;
    }
}
