package net.guerlab.smart.wx.service.service;

/**
 * 小程序-内容安全服务
 *
 * @author guer
 */
public interface WxMaContentSecurityService {

    /**
     * 校验一张图片是否含有违法违规内容
     *
     * @param appId
     *         应用ID
     * @param fileUrl
     *         图片网络地址
     */
    void checkImage(String appId, String fileUrl);

    /**
     * 检查一段文本是否含有违法违规内容
     *
     * @param appId
     *         应用ID
     * @param msg
     *         文本内容
     */
    void checkMessage(String appId, String msg);
}
