package net.guerlab.smart.wx.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.domain.WxMsgDataFormat;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 微信应用
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "wx_app")
public class WxApp extends BaseEntity implements DefaultConvertDTO<WxAppDTO> {

    /**
     * 默认企业微信应用ID
     */
    public static final Integer DEFAULT_AGENT_ID = 0;

    /**
     * appId
     */
    @Id
    private String appId;

    /**
     * 企业微信企业ID
     */
    @Column(name = "corpId", nullable = false, updatable = false)
    private String corpId;

    /**
     * 企业微信应用ID,非企业微信ID为0
     */
    @Column(name = "agentId", nullable = false, updatable = false)
    private Integer agentId;

    /**
     * secret
     */
    @Column(name = "secret", nullable = false)
    private String secret;

    /**
     * 微信应用类型
     */
    @Column(name = "wxAppType", nullable = false, updatable = false)
    private WxAppType wxAppType;

    /**
     * token
     */
    @Column(name = "token", nullable = false)
    private String token;

    /**
     * aesKey
     */
    @Column(name = "aesKey", nullable = false)
    private String aesKey;

    /**
     * 微信消息格式
     */
    @Column(name = "msgDataFormat", nullable = false)
    private WxMsgDataFormat msgDataFormat;

    /**
     * 启用标签
     */
    @Column(name = "enable", nullable = false)
    private Boolean enable;

    /**
     * 应用名称
     */
    @Column(name = "appName", nullable = false)
    private String appName;

    /**
     * 备注
     */
    @Column(name = "remark", nullable = false)
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @Column(name = "updateTime", nullable = false)
    private LocalDateTime updateTime;
}
