package net.guerlab.smart.wx.service.service;

import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.service.entity.WxUser;

/**
 * 登录服务
 *
 * @author guer
 */
public interface LoginService {

    /**
     * 登录
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @param ip
     *         ip
     * @param referer
     *         登录源
     * @return token
     */
    LoginResponse login(String appId, String code, String ip, String referer);

    /**
     * 构造登录响应
     *
     * @param user
     *         appId
     * @return 登录响应
     */
    LoginResponse buildLoginResponse(WxUser user);
}
