/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.cp.spring.storage.WxCpRedisTemplateConfigStorage;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.AfterWxAppDeleteHandler;
import net.guerlab.smart.wx.service.service.AfterWxAppUpdateHandler;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxCpManagerService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WxCpManagerServiceImpl
implements WxCpManagerService,
AfterWxAppUpdateHandler,
AfterWxAppDeleteHandler {
    private final Map<String, WxCpService> serviceMap = new ConcurrentHashMap<String, WxCpService>(8);
    private final Lock initLock = new ReentrantLock();
    private WxAppService wxAppService;
    private RedisTemplate<String, String> redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxCpService getService(String appId) {
        if ((appId = StringUtils.trimToNull((String)appId)) == null) {
            return null;
        }
        WxCpService service = this.serviceMap.get(appId);
        if (service != null) {
            return service;
        }
        this.initLock.lock();
        try {
            WxCpConfigStorage config = this.buildConfigStorage(appId);
            service = new WxCpServiceImpl();
            service.setWxCpConfigStorage(config);
            this.serviceMap.put(appId, service);
            WxCpService wxCpService = service;
            return wxCpService;
        }
        finally {
            this.initLock.unlock();
        }
    }

    private WxCpConfigStorage buildConfigStorage(String appId) {
        WxApp wxApp = (WxApp)((Object)this.wxAppService.selectById(appId));
        if (wxApp == null || wxApp.getWxAppType() != WxAppType.CP) {
            throw new WxAppInvalidException();
        }
        WxCpRedisTemplateConfigStorage storage = new WxCpRedisTemplateConfigStorage(this.redisTemplate);
        storage.setCorpId(wxApp.getAppId());
        storage.setAgentId(wxApp.getAgentId());
        storage.setCorpSecret(wxApp.getSecret());
        storage.setToken(wxApp.getToken());
        storage.setAesKey(wxApp.getAesKey());
        return storage;
    }

    @Override
    public void afterWxAppUpdateHandler(WxApp wxApp) {
        if (wxApp.getWxAppType() == WxAppType.CP) {
            this.afterWxAppDeleteHandler(wxApp.getAppId());
        }
    }

    @Override
    public void afterWxAppDeleteHandler(String appId) {
        this.initLock.lock();
        try {
            this.serviceMap.remove(appId);
        }
        finally {
            this.initLock.unlock();
        }
    }

    @Autowired
    public void setWxAppService(WxAppService wxAppService) {
        this.wxAppService = wxAppService;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

