/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import net.guerlab.smart.wx.service.mapper.WxUserLoginLogMapper;
import net.guerlab.smart.wx.service.service.AfterWxAppUpdateHandler;
import net.guerlab.smart.wx.service.service.AfterWxUserUpdateHandler;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WxUserLoginLogServiceImpl
extends BaseServiceImpl<WxUserLoginLog, Long, WxUserLoginLogMapper>
implements WxUserLoginLogService,
AfterWxUserUpdateHandler,
AfterWxAppUpdateHandler {
    @Override
    public void addLog(WxUser user, String ip, String referer) {
        if (user == null) {
            return;
        }
        WxUserLoginLog log = new WxUserLoginLog();
        log.setLoginLogId(this.sequence.nextId());
        log.setOpenId(user.getOpenId());
        log.setAppId(user.getAppId());
        log.setAppName(user.getAppName());
        log.setUnionId(user.getUnionId());
        log.setAvatarUrl(user.getAvatarUrl());
        log.setNickName(user.getNickName());
        log.setActivated(user.getActivated());
        log.setLoginTime(LocalDateTime.now());
        log.setIp(StringUtils.trimToEmpty((String)ip));
        log.setReferer(StringUtils.trimToEmpty((String)referer));
        ((WxUserLoginLogMapper)this.mapper).insertSelective(log);
    }

    @Override
    public void afterWxUserUpdateHandler(WxUser wxUser) {
        boolean noUpdate;
        String openId = StringUtils.trimToNull((String)wxUser.getOpenId());
        String unionId = StringUtils.trimToEmpty((String)wxUser.getUnionId());
        String avatarUrl = StringUtils.trimToNull((String)wxUser.getAvatarUrl());
        String nickName = StringUtils.trimToNull((String)wxUser.getNickName());
        boolean bl = noUpdate = avatarUrl == null && nickName == null;
        if (openId == null || noUpdate) {
            return;
        }
        WxUserLoginLog update = new WxUserLoginLog();
        update.setUnionId(unionId);
        update.setAvatarUrl(avatarUrl);
        update.setNickName(nickName);
        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setOpenId(openId);
        ((WxUserLoginLogMapper)this.mapper).updateByExampleSelective(update, this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public void afterWxAppUpdateHandler(WxApp wxApp) {
        String appId = StringUtils.trimToNull((String)wxApp.getAppId());
        String appName = StringUtils.trimToNull((String)wxApp.getAppName());
        if (appId == null || appName == null) {
            return;
        }
        WxUserLoginLog update = new WxUserLoginLog();
        update.setAppName(appName);
        WxUserLoginLogSearchParams searchParams = new WxUserLoginLogSearchParams();
        searchParams.setAppId(appId);
        ((WxUserLoginLogMapper)this.mapper).updateByExampleSelective(update, this.getExample((AbstractSearchParams)searchParams));
    }
}

