/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.wx.core.message.AbstractRequest;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractMsgController<Q extends AbstractRequest<?>> {
    protected WxUserService wxUserService;

    @ApiOperation(value="\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/{appId}/sendMsg"})
    public Map<String, SendMsgResponse> sendMsg(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @RequestBody Q request) {
        Collection<String> openIds = this.getOpenIds(appId, request);
        if (openIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, SendMsgResponse> result = this.sendMsg0(appId, openIds, request);
        this.afterSendMsg(appId, openIds, request);
        return result;
    }

    protected void afterSendMsg(String appId, Collection<String> openIds, Q request) {
    }

    protected Collection<String> getOpenIds(String appId, Q request) {
        Collection result;
        boolean selectAllUser;
        boolean bl = selectAllUser = request.getSelectAllUser() != null && request.getSelectAllUser() != false;
        if (selectAllUser) {
            WxUserSearchParams searchParams = new WxUserSearchParams();
            searchParams.setAppId(appId);
            result = CollectionUtil.toList((Collection)this.wxUserService.selectAll((AbstractSearchParams)searchParams), WxUser::getOpenId);
        } else {
            result = request.getOpenIds();
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected abstract Map<String, SendMsgResponse> sendMsg0(String var1, Collection<String> var2, Q var3);

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }
}

