/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.exception.AppIdInvalidException;
import net.guerlab.smart.wx.core.exception.OpenIdInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.mapper.WxUserMapper;
import net.guerlab.smart.wx.service.service.AfterWxAppUpdateHandler;
import net.guerlab.smart.wx.service.service.AfterWxUserUpdateHandler;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WxUserServiceImpl
extends BaseServiceImpl<WxUser, String, WxUserMapper>
implements WxUserService,
AfterWxAppUpdateHandler {
    private static final ThreadPoolExecutor EXECUTOR;

    @Override
    public WxUser findUser(String appId, String openId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, openId})) {
            return null;
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(appId);
        searchParams.setOpenId(openId);
        return (WxUser)((Object)this.selectOne((AbstractSearchParams)searchParams));
    }

    @Override
    public void delete(String appId, String openId) {
        String trimAppId = StringUtils.trimToNull((String)appId);
        String trimOpenId = StringUtils.trimToNull((String)openId);
        if (trimAppId == null || trimOpenId == null) {
            return;
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(trimAppId);
        searchParams.setOpenId(trimOpenId);
        ((WxUserMapper)this.mapper).deleteByExample(this.getExample((AbstractSearchParams)searchParams));
    }

    protected void insertBefore(WxUser entity) {
        String appId = StringUtils.trimToNull((String)entity.getAppId());
        String openId = StringUtils.trimToNull((String)entity.getOpenId());
        if (appId == null) {
            throw new AppIdInvalidException();
        }
        if (openId == null) {
            throw new OpenIdInvalidException();
        }
        entity.setOpenId(openId);
        entity.setAppId(appId);
        entity.setUnionId(StringUtils.trimToEmpty((String)entity.getUnionId()));
        if (entity.getActivated() == null) {
            entity.setActivated(false);
        }
    }

    protected void updateBefore(WxUser entity) {
        EXECUTOR.execute(() -> SpringApplicationContextUtil.getContext().getBeansOfType(AfterWxUserUpdateHandler.class).values().forEach(handler -> handler.afterWxUserUpdateHandler(entity)));
    }

    @Override
    public void afterWxAppUpdateHandler(WxApp wxApp) {
        String appId = wxApp.getAppId();
        String appName = StringUtils.trimToNull((String)wxApp.getAppName());
        if (appName == null) {
            return;
        }
        WxUser wxUser = new WxUser();
        wxUser.setAppName(appName);
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setAppId(appId);
        ((WxUserMapper)this.mapper).updateByExampleSelective((Object)wxUser, this.getExample((AbstractSearchParams)searchParams));
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        EXECUTOR = new ThreadPoolExecutor(availableProcessors, availableProcessors * 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setName("wxUser updateBefore");
            return thread;
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
    }
}

