/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import java.time.LocalDateTime;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.smart.wx.core.exception.AppIdInvalidException;
import net.guerlab.smart.wx.core.exception.CodeInvalidException;
import net.guerlab.smart.wx.core.exception.MaEncryptedDataInvalidException;
import net.guerlab.smart.wx.core.exception.OpenIdInvalidException;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.miniapp.spring.exception.WxMiniAppCheckUserInfoFailException;
import net.guerlab.smart.wx.miniapp.spring.exception.WxMiniAppSessionKeyInvalidException;
import net.guerlab.smart.wx.miniapp.spring.storage.ISessionKeyStorage;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxMaLoginService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.smart.wx.service.service.impl.AbstractWxLoginServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMaLoginServiceImpl
extends AbstractWxLoginServiceImpl
implements WxMaLoginService {
    private WxMaManagerService managerService;
    private ISessionKeyStorage sessionKeyStorage;

    @Override
    public LoginResponse login(String appId, String code) {
        WxMaJscode2SessionResult session;
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new CodeInvalidException();
        }
        WxApp wxApp = this.getWxApp(appId);
        WxMaUserService wxMaUserService = this.getWxMaService(appId).getUserService();
        try {
            session = wxMaUserService.getSessionInfo(code);
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
        String openId = session.getOpenid();
        String unionId = session.getUnionid();
        this.sessionKeyStorage.put(appId, openId, session.getSessionKey());
        WxUser wxUser = this.wxUserService.findUser(appId, openId);
        if (wxUser == null) {
            LocalDateTime now = LocalDateTime.now();
            wxUser = new WxUser();
            wxUser.setOpenId(openId);
            wxUser.setAppId(appId);
            wxUser.setAppName(wxApp.getAppName());
            wxUser.setUnionId(unionId);
            wxUser.setAvatarUrl("");
            wxUser.setNickName("");
            wxUser.setRegistryTime(now);
            wxUser.setLastLoginTime(now);
            wxUser.setActivated(false);
            this.wxUserService.insert((Object)wxUser);
            this.wxUserLoginLogService.addLog(wxUser);
        } else {
            this.updateUserInfo(wxUser, openId, unionId, false);
        }
        return this.buildLoginResponse(wxUser);
    }

    @Override
    public LoginResponse register(String appId, String openId, MaEncryptedData encryptedData) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new AppIdInvalidException();
        }
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new OpenIdInvalidException();
        }
        if (encryptedData == null) {
            throw new MaEncryptedDataInvalidException();
        }
        String sessionKey = this.sessionKeyStorage.get(appId, openId);
        if (StringUtils.isBlank((CharSequence)sessionKey)) {
            throw new WxMiniAppSessionKeyInvalidException();
        }
        WxMaUserService wxMaUserService = this.getWxMaService(appId).getUserService();
        if (!wxMaUserService.checkUserInfo(sessionKey, encryptedData.getRawData(), encryptedData.getSignature())) {
            throw new WxMiniAppCheckUserInfoFailException();
        }
        WxMaUserInfo userInfo = wxMaUserService.getUserInfo(sessionKey, encryptedData.getEncryptedData(), encryptedData.getIv());
        WxUser wxUser = this.wxUserService.findUser(appId, openId);
        LocalDateTime now = LocalDateTime.now();
        if (wxUser == null) {
            WxApp wxApp = (WxApp)((Object)this.wxAppService.selectByIdOptional(appId).orElseThrow(WxAppInvalidException::new));
            wxUser = new WxUser();
            wxUser.setOpenId(openId);
            wxUser.setAppId(appId);
            wxUser.setAppName(wxApp.getAppName());
            wxUser.setUnionId(userInfo.getUnionId());
            wxUser.setAvatarUrl(userInfo.getAvatarUrl());
            wxUser.setNickName(userInfo.getNickName());
            wxUser.setActivated(true);
            this.wxUserService.insertSelective((Object)wxUser);
        } else {
            WxUser update = new WxUser();
            update.setOpenId(openId);
            update.setAppId(wxUser.getAppId());
            update.setUnionId(userInfo.getUnionId());
            update.setAvatarUrl(userInfo.getAvatarUrl());
            update.setNickName(userInfo.getNickName());
            update.setLastLoginTime(now);
            update.setVersion(wxUser.getVersion());
            update.setActivated(true);
            this.wxUserService.updateSelectiveById((Object)update);
            wxUser.setUnionId(userInfo.getUnionId());
            wxUser.setAvatarUrl(userInfo.getAvatarUrl());
            wxUser.setNickName(userInfo.getNickName());
            wxUser.setLastLoginTime(now);
            wxUser.setActivated(true);
        }
        return this.buildLoginResponse(wxUser);
    }

    private WxMaService getWxMaService(String appId) {
        return this.managerService.getService(appId);
    }

    @Autowired
    public void setManagerService(WxMaManagerService managerService) {
        this.managerService = managerService;
    }

    @Autowired
    public void setSessionKeyStorage(ISessionKeyStorage sessionKeyStorage) {
        this.sessionKeyStorage = sessionKeyStorage;
    }
}

