/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Tag(name = "微信用户登录记录")
@RestController("/inside/wxUserLoginLog")
@RequestMapping("/inside/wxUserLoginLog")
public class WxUserLoginLogController {

    private WxUserLoginLogService service;

    @Operation(description = "根据搜索参数查询用户登录记录分页列表")
    @PostMapping
    public ListObject<WxUserLoginLogDTO> findList(@RequestBody WxUserLoginLogSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @Operation(description = "根据搜索参数查询全部用户登录记录")
    @PostMapping("/all")
    public Collection<WxUserLoginLogDTO> findAll(@RequestBody WxUserLoginLogSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(WxUserLoginLogService service) {
        this.service = service;
    }
}
