/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.service.service.WxMpLoginService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 公众号
 *
 * @author guer
 */
@Tag(name = "公众号")
@RestController("/inside/wx/mp")
@RequestMapping("/inside/wx/mp")
@Transactional(rollbackFor = Exception.class)
public class WxMpController {

    private WxMpLoginService loginService;

    private WxMpManagerService managerService;

    @Operation(description = "登录")
    @GetMapping("/{appId}/login/{code}")
    public LoginResponse login(@Parameter(name = "应用ID", required = true) @PathVariable String appId, @Parameter(name = "code", required = true) @PathVariable String code, HttpServletRequest request) {
        return loginService.login(appId, code, IpUtils.getIp(request), "inside", null);
    }

    @Operation(description = "获取")
    @GetMapping("/{appId}/accessToken")
    public Result<String> getAccessToken(@Parameter(name = "应用ID", required = true) @PathVariable String appId) {
        try {
            return new Succeed<>(Succeed.MSG, managerService.getService(appId).getAccessToken());
        } catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e, e.getError().getErrorCode());
        }
    }

    @Autowired
    public void setLoginService(WxMpLoginService loginService) {
        this.loginService = loginService;
    }

    @Autowired
    public void setManagerService(WxMpManagerService managerService) {
        this.managerService = managerService;
    }
}
