/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 小程序-内容安全
 *
 * @author guer
 */
@Tag(name = "小程序-内容安全")
@RestController("/inside/wxMaContentSecurity")
@RequestMapping("/inside/wxMaContentSecurity")
public class WxMaContentSecurityController {

    private WxMaContentSecurityService service;

    @Operation(description = "校验一张图片是否含有违法违规内容")
    @PostMapping("/{appId}/checkImage")
    public void checkImage(@Parameter(name = "应用ID", required = true) @PathVariable String appId, @Parameter(name = "图片网络地址", required = true) @RequestBody String fileUrl) {
        service.checkImage(appId, fileUrl);
    }

    @Operation(description = "检查一段文本是否含有违法违规内容")
    @PostMapping("/{appId}/checkMessage")
    public void checkMessage(@Parameter(name = "应用ID", required = true) @PathVariable String appId, @Parameter(name = "文本内容", required = true) @RequestBody String msg) {
        service.checkMessage(appId, msg);
    }

    @Autowired
    public void setService(WxMaContentSecurityService service) {
        this.service = service;
    }
}
