/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 微信应用
 *
 * @author guer
 */
@Tag(name = "微信应用")
@RestController("/inside/wxApp")
@RequestMapping("/inside/wxApp")
public class WxAppController {

    private WxAppService service;

    @Operation(description = "根据AppId查询微信应用")
    @GetMapping("/{appId}")
    public WxAppDTO findOne(@Parameter(name = "appId", required = true) @PathVariable String appId) {
        return service.selectByIdOptional(appId).orElseThrow(WxAppInvalidException::new).convert();
    }

    @Operation(description = "根据搜索参数查询微信应用分页列表")
    @PostMapping
    public ListObject<WxAppDTO> findList(@RequestBody WxAppSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @Operation(description = "根据搜索参数查询全部微信应用")
    @PostMapping("/all")
    public Collection<WxAppDTO> findAll(@RequestBody WxAppSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(WxAppService service) {
        this.service = service;
    }
}
