/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5fae\u4fe1\u7528\u6237")
@RestController(value="/inside/wxUser")
@RequestMapping(value={"/inside/wxUser"})
public class WxUserController {
    private WxUserService service;

    @Operation(description="\u6839\u636eAppId\u548cOpenId\u67e5\u8be2\u7528\u6237")
    @GetMapping(value={"/{appId}/{openId}"})
    public WxUserDTO findOne(@Parameter(name="appId", required=true) @PathVariable String appId, @Parameter(name="openId", required=true) @PathVariable String openId) {
        WxUser wxUser = this.service.findUser(appId, openId);
        if (wxUser == null) {
            throw new WxUserInvalidException();
        }
        return wxUser.convert();
    }

    @Operation(description="\u6839\u636e\u641c\u7d22\u53c2\u6570\u67e5\u8be2\u7528\u6237\u5206\u9875\u5217\u8868")
    @PostMapping
    public ListObject<WxUserDTO> findList(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.queryPage(searchParams));
    }

    @Operation(description="\u6839\u636e\u641c\u7d22\u53c2\u6570\u67e5\u8be2\u5168\u90e8\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/all"})
    public Collection<WxUserDTO> findAll(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.queryAll(searchParams));
    }

    @Operation(description="\u6839\u636e\u641c\u7d20\u53c2\u6570\u67e5\u8be2\u7528\u6237\u8868")
    @PostMapping(value={"/findMap"})
    public Map<String, WxUserDTO> findMap(@RequestBody Collection<String> openIds) {
        if (openIds == null || openIds.isEmpty()) {
            return Collections.emptyMap();
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setOpenIds(openIds);
        Collection wxUsers = this.service.selectAll((AbstractSearchParams)searchParams);
        return CollectionUtil.toMap((Collection)wxUsers, WxUser::getOpenId, WxUser::convert);
    }

    @Operation(description="\u6839\u636e\u641c\u7d22\u53c2\u6570\u67e5\u8be2\u7528\u6237\u6570\u91cf")
    @PostMapping(value={"/count"})
    public int findCount(WxUserSearchParams searchParams) {
        return this.service.selectCount((AbstractSearchParams)searchParams);
    }

    @Autowired
    public void setService(WxUserService service) {
        this.service = service;
    }
}

