/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.smart.wx.service.service.WxCpManagerService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4f01\u4e1a\u5fae\u4fe1")
@RestController(value="/inside/wx/cp")
@RequestMapping(value={"/inside/wx/cp"})
@Transactional(rollbackFor={Exception.class})
public class WxCpController {
    private WxCpManagerService managerService;

    @Operation(description="\u6839\u636eAppId\u83b7\u53d6AccessToken")
    @GetMapping(value={"/{appId}/accessToken"})
    public Result<String> getAccessToken(@Parameter(name="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        try {
            return new Succeed("success", (Object)this.managerService.getService(appId).getAccessToken());
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
    }

    @Operation(description="\u901a\u8fc7code\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/{appId}/{code}/getCodeInfo"})
    public WxCpOauth2UserInfoDTO getCodeInfo(@Parameter(name="\u5e94\u7528ID", required=true) @PathVariable String appId, @Parameter(name="code", required=true) @PathVariable String code) {
        try {
            WxCpOauth2UserInfo userInfo = this.managerService.getService(appId).getOauth2Service().getUserInfo(code);
            WxCpOauth2UserInfoDTO dto = new WxCpOauth2UserInfoDTO();
            dto.setOpenId(userInfo.getOpenId());
            dto.setDeviceId(userInfo.getDeviceId());
            dto.setUserId(userInfo.getUserId());
            dto.setUserTicket(userInfo.getUserTicket());
            dto.setExpiresIn(userInfo.getExpiresIn());
            return dto;
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
    }

    @Autowired
    public void setManagerService(WxCpManagerService managerService) {
        this.managerService = managerService;
    }
}

