/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.smart.wx.service.service.WxMaLoginService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f"})
@RestController(value="/inside/wx/ma")
@RequestMapping(value={"/inside/wx/ma"})
public class WxMaController {
    private WxMaLoginService loginService;
    private WxMaManagerService managerService;

    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/{appId}/login/{code}"})
    public LoginResponse login(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="code", required=true) @PathVariable String code, HttpServletRequest request) {
        return this.loginService.login(appId, code, IpUtils.getIp((HttpServletRequest)request), "inside", null);
    }

    @ApiOperation(value="\u6ce8\u518c")
    @PostMapping(value={"/{appId}/register/{openId}"})
    public LoginResponse register(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="openId", required=true) @PathVariable String openId, @RequestBody MaEncryptedData encryptedData, HttpServletRequest request) {
        return this.loginService.register(appId, openId, encryptedData, null, IpUtils.getIp((HttpServletRequest)request));
    }

    @ApiOperation(value="\u83b7\u53d6accessToken")
    @GetMapping(value={"/{appId}/accessToken"})
    public Result<String> getAccessToken(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        try {
            return new Succeed("success", (Object)this.managerService.getService(appId).getAccessToken());
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
    }

    @Autowired
    public void setLoginService(WxMaLoginService loginService) {
        this.loginService = loginService;
    }

    @Autowired
    public void setManagerService(WxMaManagerService wxMaManagerService) {
        this.managerService = wxMaManagerService;
    }
}

