package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.service.service.WxMpLoginService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公众号
 *
 * @author guer
 */
@Api(tags = "公众号")
@RestController("/inside/wx/mp")
@RequestMapping("/inside/wx/mp")
@Transactional(rollbackFor = Exception.class)
public class WxMpController {

    private WxMpLoginService loginService;

    private WxMpManagerService managerService;

    @ApiOperation("登录")
    @GetMapping("/{appId}/login/{code}")
    public LoginResponse login(@ApiParam(value = "应用ID", required = true) @PathVariable String appId,
            @ApiParam(value = "code", required = true) @PathVariable String code) {
        return loginService.login(appId, code, "inside", "inside");
    }

    @ApiOperation("获取")
    @GetMapping("/{appId}/accessToken")
    public Result<String> getAccessToken(@ApiParam(value = "应用ID", required = true) @PathVariable String appId) {
        try {
            return new Succeed<>(Succeed.MSG, managerService.getService(appId).getAccessToken());
        } catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e, e.getError().getErrorCode());
        }
    }

    @Autowired
    public void setLoginService(WxMpLoginService loginService) {
        this.loginService = loginService;
    }

    @Autowired
    public void setManagerService(WxMpManagerService wxMpManagerService) {
        this.managerService = wxMpManagerService;
    }
}
