package net.guerlab.smart.wx.internal.controller.inside;

import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@RestController("/inside/wxUserLoginLog")
@RequestMapping("/inside/wxUserLoginLog")
public class WxUserLoginLogController {

    private WxUserLoginLogService service;

    @PostMapping
    public ListObject<WxUserLoginLogDTO> findList(@RequestBody WxUserLoginLogSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<WxUserLoginLogDTO> findAll(@RequestBody WxUserLoginLogSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(WxUserLoginLogService service) {
        this.service = service;
    }
}
