package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 微信应用
 *
 * @author guer
 */
@RestController("/inside/wxApp")
@RequestMapping("/inside/wxApp")
public class WxAppController {

    private WxAppService service;

    @GetMapping("/{appId}")
    public WxAppDTO findOne(@ApiParam(value = "appId", required = true) @PathVariable String appId) {
        return service.selectByIdOptional(appId).orElseThrow(WxAppInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<WxAppDTO> findList(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<WxAppDTO> findAll(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(WxAppService service) {
        this.service = service;
    }
}
