/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import java.util.Collection;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/inside/wxUser")
@RequestMapping(value={"/inside/wxUser"})
public class WxUserController {
    private WxUserService service;

    @GetMapping(value={"/{appId}/{openId}"})
    public WxUserDTO findOne(@ApiParam(value="appId", required=true) @PathVariable String appId, @ApiParam(value="openId", required=true) @PathVariable String openId) {
        WxUser wxUser = this.service.findUser(appId, openId);
        if (wxUser == null) {
            throw new WxUserInvalidException();
        }
        return wxUser.toDTO();
    }

    @PostMapping
    public ListObject<WxUserDTO> findList(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @PostMapping(value={"/all"})
    public Collection<WxUserDTO> findAll(@RequestBody WxUserSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setService(WxUserService service) {
        this.service = service;
    }
}

